/*
 * Decompiled with CFR 0.152.
 */
package vectorwing.farmersdelight.crafting.ingredients;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.minecraftforge.registries.ForgeRegistries;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class ToolIngredient
extends Ingredient {
    public static final Serializer SERIALIZER = new Serializer();
    public final ToolType toolType;

    public ToolIngredient(ToolType toolType) {
        super(ForgeRegistries.ITEMS.getValues().stream().map(ItemStack::new).filter(stack -> stack.getToolTypes().contains(toolType)).map(Ingredient.SingleItemList::new));
        this.toolType = toolType;
    }

    public boolean test(@Nullable ItemStack stack) {
        return stack != null && stack.getToolTypes().contains(this.toolType) || super.test(stack);
    }

    public JsonElement func_200304_c() {
        JsonObject json = new JsonObject();
        json.addProperty("type", CraftingHelper.getID((IIngredientSerializer)SERIALIZER).toString());
        json.addProperty("tool", this.toolType.getName());
        return json;
    }

    public IIngredientSerializer<? extends Ingredient> getSerializer() {
        return SERIALIZER;
    }

    public static class Serializer
    implements IIngredientSerializer<ToolIngredient> {
        public ToolIngredient parse(JsonObject json) {
            return new ToolIngredient(ToolType.get((String)json.get("tool").getAsString()));
        }

        public ToolIngredient parse(PacketBuffer buffer) {
            return new ToolIngredient(ToolType.get((String)buffer.func_218666_n()));
        }

        public void write(PacketBuffer buffer, ToolIngredient ingredient) {
            buffer.func_180714_a(ingredient.toolType.getName());
        }
    }
}

